﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Public Class MainForm

    Private Sub DisplayTSProperties(ByVal ts As TimeSpan)
        '使用 TimeSpan 类型的实例属性。
        '演示：
        '  TimeSpan.Days
        '  TimeSpan.Hours
        '  TimeSpan.Milliseconds
        '  TimeSpan.Minutes
        '  TimeSpan.Seconds
        '  TimeSpan.Ticks
        '  TimeSpan.TotalDays
        '  TimeSpan.TotalHours
        '  TimeSpan.TotalMilliseconds
        '  TimeSpan.TotalMinutes
        '  TimeSpan.TotalSeconds
        Try
            Days.Text = ts.Days.ToString
            Hours.Text = ts.Hours.ToString
            Milliseconds.Text = ts.Milliseconds.ToString
            Minutes.Text = ts.Minutes.ToString
            Seconds.Text = ts.Seconds.ToString
            TimeSpanTicks.Text = ts.Ticks.ToString
            TotalDays.Text = ts.TotalDays.ToString
            TotalHours.Text = ts.TotalHours.ToString
            TotalMilliseconds.Text = ts.TotalMilliseconds.ToString
            TotalMinutes.Text = ts.TotalMinutes.ToString
            TotalSeconds.Text = ts.TotalSeconds.ToString
        Catch ex As Exception
            MessageBox.Show(ex.Message, Me.Text)
        End Try
    End Sub

    Private Sub LoadCalculationMethods()
        '使用 DateTime 类型的实例方法。
        '演示：
        '  DateTime.AddDays
        '  DateTime.AddHours
        '  DateTime.AddMilliseconds
        '  DateTime.AddMinutes
        '  DateTime.AddMonths
        '  DateTime.AddSeconds
        '  DateTime.AddTicks
        '  DateTime.AddYears
        Try
            Dim dateNow As DateTime = DateTime.Now
            lblNow3.Text = dateNow.ToString

            AddDaysLabel.Text = dateNow.AddDays(CDbl(AddDays.Text)).ToString
            AddHoursLabel.Text = dateNow.AddHours(CDbl(AddHours.Text)).ToString
            AddMillisecondsLabel.Text = dateNow.AddMilliseconds(CDbl(AddMilliseconds.Text)).ToString
            AddMinutesLabel.Text = dateNow.AddMinutes(CDbl(AddMinutes.Text)).ToString
            AddMonthsLabel.Text = dateNow.AddMonths(CInt(AddMonths.Text)).ToString
            AddSecondsLabel.Text = dateNow.AddSeconds(CDbl(AddSeconds.Text)).ToString
            AddTicksLabel.Text = dateNow.AddTicks(CLng(AddTicks.Text)).ToString
            AddYearsLabel.Text = dateNow.AddYears(CInt(AddYears.Text)).ToString
        Catch ex As Exception
            MessageBox.Show(ex.Message, Me.Text)
        End Try
    End Sub

    Private Sub LoadConversionMethods()
        '使用 DateTime 类型的实例方法。
        '演示：
        '  DateTime.ToFileTime
        '  DateTime.ToLocalTime
        '  DateTime.ToLongDateString
        '  DateTime.ToLongTimeString
        '  DateTime.ToOADate
        '  DateTime.ToShortDateString
        '  DateTime.ToShortTimeString
        '  DateTime.ToString
        '  DateTime.ToUniversalTime
        Try
            Dim dateNow As DateTime = DateTime.Now

            Now2Label.Text = dateNow.ToString
            ToFileTime.Text = dateNow.ToFileTime.ToString
            ToLocalTime.Text = dateNow.ToLocalTime.ToString
            ToLongDateString.Text = dateNow.ToLongDateString
            ToLongTimeString.Text = dateNow.ToLongTimeString
            ToOADate.Text = dateNow.ToOADate.ToString
            ToShortDateString.Text = dateNow.ToShortDateString
            ToShortTimeString.Text = dateNow.ToShortTimeString
            ToStringLabel.Text = dateNow.ToString
            ToUniversalTime.Text = dateNow.ToUniversalTime.ToString
        Catch ex As Exception
            MessageBox.Show(ex.Message, Me.Text)
        End Try
    End Sub

    Private Sub LoadProperties()
        '使用 DateTime 类型
        '的实例属性。
        '演示：
        '  DateTime.Now
        '  DateTime.Date
        '  DateTime.Day
        '  DateTime.DayOfYear
        '  DateTime.Hour
        '  DateTime.Millisecond
        '  DateTime.DayOfWeek
        '  DateTime.Minute
        '  DateTime.Month
        '  DateTime.Second
        '  DateTime.Ticks
        '  DateTime.TimeOfDay
        '  DateTime.Year
        Try
            '除非需要在创建实例
            '时指定值，否则无需
            '使用显式构造函数。
            Dim dateNow As DateTime = DateTime.Now

            NowPropertyLabel.Text = dateNow.ToString
            DateLabel.Text = dateNow.Date.ToString
            Day.Text = dateNow.Day.ToString
            DayOfYear.Text = dateNow.DayOfYear.ToString
            Hour.Text = dateNow.Hour.ToString
            Millisecond.Text = dateNow.Millisecond.ToString
            DayOfWeek.Text = dateNow.DayOfWeek.ToString
            Minute.Text = dateNow.Minute.ToString
            Month.Text = dateNow.Month.ToString
            Second.Text = dateNow.Second.ToString
            Ticks.Text = dateNow.Ticks.ToString
            TimeOfDay.Text = dateNow.TimeOfDay.ToString
            Year.Text = dateNow.Year.ToString
        Catch ex As Exception
            MessageBox.Show(ex.Message, Me.Text)
        End Try
    End Sub

    Private Sub LoadSharedMembers()
        '使用 DateTime 类型的共享成员。
        '演示这些属性：
        '  DateTime.Now 
        '     获取一个 DateTime，它是此计算机上的当前本地日期和时间。
        '  DateTime.UtcNow
        '    获取一个 DateTime，它是此计算机上的当前本地日期和时间，
        '    并用协调通用时间 (UTC) 表示。
        '  DateTime.MinValue
        '    表示 DateTime 的最小可能值。此字段为只读字段。
        '  DateTime.MaxValue
        '    表示 DateTime 的最大可能值。此字段为只读字段。

        ' 演示这些方法：
        '  DateTime.FromOADate
        '    返回与指定的 OLE 自动化日期相当的 DateTime。
        '  DateTime.IsLeapYear
        '    返回信息指示指定年是否为闰年。
        '  DateTime.DaysInMonth
        '    返回指定年的指定月份中的天数。
        Try
            NowLabel.Text = DateTime.Now.ToString
            TodayLabel.Text = DateTime.Today.ToString
            UtcNowLabel.Text = DateTime.UtcNow.ToString
            MinValue.Text = DateTime.MinValue.ToString
            MaxValue.Text = DateTime.MaxValue.ToString

            FromOADateLabel.Text = DateTime.FromOADate(CDbl(FromOADate.Text)).ToString
            IsLeapYearLabel.Text = DateTime.IsLeapYear(CInt(IsLeapYear.Text)).ToString
            DaysInMonthLable.Text = DateTime.DaysInMonth( _
             CInt(YearDaysInMonth.Text), CInt(MonthDaysInMonth.Text)).ToString
        Catch ex As Exception
            MessageBox.Show(ex.Message, Me.Text)
        End Try
    End Sub

    Private Sub LoadTimeSpanFields()
        '使用 TimeSpan 类型提供的共享字段。
        '演示：
        '  TimeSpan.MaxValue
        '  TimeSpan.Minvalue
        '  TimeSpan.TicksPerDay
        '  TimeSpan.TicksPerHour
        '  TimeSpan.TicksPerMillisecond
        '  TimeSpan.TicksPerMinute
        '  TimeSpan.TicksPerSecond
        '  TimeSpan.Zero
        Try
            MaxValueTS.Text = TimeSpan.MaxValue.ToString
            MinValueTS.Text = TimeSpan.MinValue.ToString
            TicksPerDay.Text = TimeSpan.TicksPerDay.ToString
            TicksPerHour.Text = TimeSpan.TicksPerHour.ToString
            TicksPerMillisecond.Text = TimeSpan.TicksPerMillisecond.ToString
            TicksPerMinute.Text = TimeSpan.TicksPerMinute.ToString
            TicksPerSecond.Text = TimeSpan.TicksPerSecond.ToString
            Zero.Text = TimeSpan.Zero.ToString
        Catch ex As Exception
            MessageBox.Show(ex.Message, Me.Text)
        End Try
    End Sub

    Private Sub LoadTSMethods()
        '使用 TimeSpan 类型的共享方法。
        '演示：
        '  TimeSpan.FromDays
        '  TimeSpan.FromHours
        '  TimeSpan.FromMilliseconds
        '  TimeSpan.FromMinutes
        '  TimeSpan.FromSeconds
        '  TimeSpan.FromTicks
        Try
            FromDaysLabel.Text = TimeSpan.FromDays(CDbl(FromDays.Text)).ToString
            FromHoursLabel.Text = TimeSpan.FromHours(CDbl(FromHours.Text)).ToString
            FromMillisecondsLabel.Text = TimeSpan.FromMilliseconds(CDbl(FromMilliseconds.Text)).ToString
            FromMinutesLabel.Text = TimeSpan.FromMinutes(CDbl(FromMinutes.Text)).ToString
            FromSecondsLabel.Text = TimeSpan.FromSeconds(CDbl(FromSeconds.Text)).ToString
            FromTicksLabel.Text = TimeSpan.FromTicks(CLng(FromTicks.Text)).ToString
        Catch ex As Exception
            MessageBox.Show(ex.Message, Me.Text)
        End Try
    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        '调用可向窗体中加载值的过程。
        LoadSharedMembers()
        LoadProperties()
        LoadConversionMethods()
        LoadCalculationMethods()
        LoadTimeSpanFields()
        LoadTSMethods()

    End Sub

    Private Sub btnRefreshShared_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RefreshShared.Click
        LoadSharedMembers()
    End Sub

    Private Sub btnRefreshCalculation_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RefreshCalculation.Click
        LoadCalculationMethods()
    End Sub

    Private Sub btnRefreshProperties_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RefreshProperties.Click
        LoadProperties()
    End Sub

    Private Sub btnRefreshConversion_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RefreshConversion.Click
        LoadConversionMethods()
    End Sub

    Private Sub btnRefreshTSProperties_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RefreshTSProperties.Click
        Try
            '基于窗体中提供的 DateTime 值
            '创建 TimeSpan 实例。
            Dim ts As TimeSpan
            Dim startDate As DateTime
            Dim endDate As DateTime

            '分析文本框中的文本。
            startDate = DateTime.Parse(StartTime.Text)
            endDate = DateTime.Parse(EndTime.Text)
            ts = endDate.Subtract(startDate).Duration

            '显示已创建的 TimeSpan
            '实例的属性。
            DisplayTSProperties(ts)
        Catch Ex As Exception
            MessageBox.Show(Ex.Message, Me.Text)
        End Try
    End Sub

    Private Sub btnCalcParse_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCalcParse.Click
        '对于给定的包含要分析的 TimeSpan 值的字符串，
        '显示 TimeSpan 属性。
        Try
            '除非需要在创建实例
            '时指定值，否则无需
            '使用显式构造函数。
            Dim ts As TimeSpan
            ts = TimeSpan.Parse(txtParse.Text)

            '显示已创建的 TimeSpan
            '实例的属性。
            DisplayTSProperties(ts)
        Catch ex As Exception
            MessageBox.Show(ex.Message, Me.Text)
        End Try
    End Sub

    Private Sub btnRefreshTSMethods_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RefreshTSMethods.Click
        LoadTSMethods()
    End Sub

    Private Sub exitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub
End Class
